ProgressCircle = Core.class(Sprite)

function ProgressCircle:init(full_circle_texture, half_blank_texture)
	
	self.full_circle_bitmap = Bitmap.new(full_circle_texture)
	self.half_blank_bitmap_1 = Bitmap.new(half_blank_texture)
	self.half_blank_bitmap_2 = Bitmap.new(half_blank_texture)
	
	-- Make a bitmap of the 0 to 50% side of the full progress circle:
	local circle_w = self.full_circle_bitmap:getWidth()
	local circle_h = self.full_circle_bitmap:getHeight()
	local circle_center_x = circle_w / 2
	local circle_center_y = circle_h / 2
	
	local texture_region = TextureRegion.new(full_circle_texture, circle_center_x, 0, circle_center_x, circle_h)
	self.half_done_bitmap = Bitmap.new(texture_region)
	self.half_done_bitmap:setPosition(circle_center_x, 0)	
	
	self:addChild(self.full_circle_bitmap)
	
	-- Make half blank circles rotate around the circle center:
	self.half_blank_bitmap_1:setAnchorPoint(1, 0.5)
	self.half_blank_bitmap_2:setAnchorPoint(1, 0.5)
	
	-- Position them over the center of the full progress circle:
	self:addChild(self.half_blank_bitmap_1)
	self.half_blank_bitmap_1:setPosition(circle_center_x, circle_center_y)
	self:addChild(self.half_blank_bitmap_2)
	self.half_blank_bitmap_2:setPosition(circle_center_x, circle_center_y)
	
	-- Enlarge them slightly to ensure complete overlap:	
	self.half_blank_bitmap_1:setScale(1.05)
	self.half_blank_bitmap_2:setScale(1.05)
	
	self:setProgress(0.0)
end

function ProgressCircle:setProgress(progress_in) -- 0 to 1
	local progress = math.max(math.min(progress_in, 1), 0)
	if (progress < 0.5) then
		-- Rotate one of the half blank circles to expose the appropriate part of the completed circle:
		self.half_blank_bitmap_2:setRotation(progress * 360 + 180)
		self.half_blank_bitmap_1:setRotation(0)
		
		-- Make sure the half-done bitmap isn't shown:
		if self.half_done_bitmap:getParent() == self then
			self:removeChild(self.half_done_bitmap)
		end
	else
		-- rotate half blank on 50-100% side, and overlap with a copy of the 0-50% side of complete circle:
		if self.half_done_bitmap:getParent() ~= self then
			self:addChild(self.half_done_bitmap)
		end
		
		-- Hide one half blank completely under the half_done_bitmap
		self.half_blank_bitmap_1:setRotation(180)
		
		-- Expose part of the otheer half blank:
		self.half_blank_bitmap_2:setRotation(180 - (1 - progress) * 360)
	end
end
