
local fullCircleTexture = Texture.new("gfx/full_progress_circle.png")
local halfBlankCircleTexture = Texture.new("gfx/blank_half_circle.png")


local prog_circle = ProgressCircle.new(fullCircleTexture, halfBlankCircleTexture)
prog_circle:setPosition(200, 200)
stage:addChild(prog_circle)

local progress = 0.0
local progress_step = 0.01

-- Set the progress 200 times, every 100 milliseconds:
local timer = Timer.new(100, 200)

local function on_timer()
	progress = progress + progress_step
	prog_circle:setProgress(progress)
	-- After testing increasing progress, let's reverse it and see progress reduced:
	if (progress > 1.0) and progress_step > 0 then
		progress_step = progress_step * -1
	end
end

timer:addEventListener(Event.TIMER, on_timer)
timer:start()

